package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 开票申请
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
public class InvoiceApplyDto implements Serializable {
     
    private static final long serialVersionUID = 17332067335558145L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 归属项目ID
     */
    private Long projectId;

    /**
     * 主结算单ID
     */
    private Long mainSettlementId;

    /**
     * 兑吧主体
     */
    private Long duibaSubject;

    /**
     * 开票总金额
     */
    private Long totalAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 状态：1-申请中，2-申请失败，3-审批拒绝，4-待开票，5-部分开票，6-待回款，7-已回款
     */
    private Integer invoiceApplyStatus;

    /**
     * 锁定版本
     */
    private Integer lockVersion;

    /**
     * 锁定状态: 1-未锁定，2-锁定中，3-锁定成功，4-锁定失败，5-解锁中，6-解锁成功，7-解锁失败
     */
    private Integer lockStatus;

    /**
     * 审批状态：1-待提交，2-提交失败，3-审核中，4-已撤回，5-已打回，6-已通过，7-已删除
     */
    private Integer approvalStatus;

    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 全部票的压缩包文件地址
     */
    private String allZipUrl;

    /**
     * 创建人钉钉用户ID
     */
    private String dingTalkUserId;

    /**
     * 创建人钉钉部门id
     */
    private Long dingTalkDeptId;

    /**
     * 审批备注
     */
    private String approvalRemark;

    /**
     * 预付款总抵扣金额
     */
    private Long prepaymentDeductionTotalAmount;

    /**
     * 预付款当前抵扣金额
     */
    private Long prepaymentDeductionAmount;
}