package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 发票回款状态枚举
 * @author yinjiaqi
 * @date 2025-04-09 14:57:02
 */
@AllArgsConstructor
@Getter
public enum InvoiceReceivedStatusEnum {
    NO_RECEIVED(1, "未回款"),
    PART_RECEIVED(2, "部分回款"),
    ALREADY_RECEIVED(3, "已回款"),
    ;
    private static final Map<Integer, InvoiceReceivedStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InvoiceReceivedStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    private final Integer status;
    private final String desc;

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static InvoiceReceivedStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
