package cn.com.duiba.quanyi.center.api.dto.contract;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/5/8 19:42
 **/
@Data
public class ContractEsDto implements Serializable {
    private static final long serialVersionUID = 2513715105647979099L;

    /**
     * id
     */
    private Long id;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 客户主体
     */
    private String partnerSubject;
    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人id（条件）
     */
    private Long createPersonId;

    /**
     * 合同ID 集合我的合同详情定制字段
     */
    private List<Long> ssoUserList;

    /**
     * 关联的项目ID
     */
    private Long projectId;

    /**
     * 合同类型
     * {@link cn.com.duiba.quanyi.center.api.enums.contract.ContractTypeEnum}
     */
    private Integer contractType;

    /**
     * 合同ID 创建日期+编号
     */
    private String contractNo;

    /**
     * 所属业务
     * @see BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;

    /**
     * 合同状态
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractStatusEnum
     */
    private Integer contractStatus;

    /**
     * 创建时间 yyyy-MM-dd HH:mm:ss
     */
    private String gmtCreate;

    /**
     * 是否已超额
     */
    private Boolean hasOverAmount;
}
