package cn.com.duiba.quanyi.center.api.dto.qy.statement;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单需求商品表
 * @author mybatis generator 
 * @date 2024-07-18
 */
@Data
public class StatementDemandGoodsDto implements Serializable {
     
    private static final long serialVersionUID = 17212964871102579L;

    /**
     * 唯一标识，每条记录一个唯一值
     */
    private Long id;

    /**
     * 结算单ID
     */
    private Long statementId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 合同商品ID
     */
    private Long contractGoodsId;

    /**
     * 打款明细ID
     */
    private Long paymentDetailId;

    /**
     * 打款明细金额
     */
    private Long paymentAmount;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 核销笔数
     */
    private Long verifiedCount;

    /**
     * 立减金核销金额
     */
    private Long discountVerifiedAmount;

    /**
     * 立减金退款金额
     */
    private Long discountRefundAmount;

    /**
     * 核销净额
     */
    private Long netVerifiedAmount;

    /**
     * 开票金额
     */
    private Long invoicedAmount;

    /**
     * 打款日期
     */
    private Date paymentDate;

    /**
     * 结算开始日期
     */
    private Date settlementStartDate;

    /**
     * 结算结束日期
     */
    private Date settlementEndDate;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}