package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractStockDto;

/**
 * 合同库存RemoteService
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
@AdvancedFeignClient
public interface RemoteContractStockService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合同库存信息
     */
    ContractStockDto selectById(Long id);

    /**
     * 根据合同ID查询
     *
     * @param contractId 合同ID
     * @return 合同库存信息
     */
    ContractStockDto selectByContractId(Long contractId);

    /**
     * 新增
     *
     * @param dto 合同库存信息
     * @return 执行结果
     */
    int insert(ContractStockDto dto);

    /**
     * 更新
     *
     * @param dto 合同库存信息
     * @return 执行结果
     */
    int update(ContractStockDto dto);

    /**
     * 乐观锁更新剩余金额
     *
     * @param id 主键
     * @param surplusAmount 剩余金额
     * @param lockVersion 版本号
     * @return 执行结果
     */
    int updateSurplusAmountOptimistic(Long id, Long surplusAmount, Integer lockVersion);
}
