package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandContractRefDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandInfoDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandGoodsCompletePurchaseParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageEsParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPurchaseRecordSaveOrUpdateParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandService {
    /**
     * 根据主键查询
     *
     * @param list 主键
     * @return 需求
     */
    Map<Long, DemandDto> selectByIdList(Set<Long> list);

    /**
     * 根据对接人id查询
     * @param contactsId 对接人id
     * @return 需求id集合
     */
    List<Long> selectDemandIdListByContactsId(Long contactsId);

    /**
     * 根据需求id集合查询需求名称
     * @param list 需求id集合
     * @return 需求id: 需求名称
     */
    Map<Long, String> selectDemandNameMap(Set<Long> list);

    /**
     * 分页查询
     *
     * @param param 请求参数
     * @return 需求列表
     */
    List<DemandDto> selectPage(DemandPageQueryParam param);

    /**
     * 分页查询(ES专用）
     *
     * @param param 请求参数
     * @return 需求列表
     */
    Pair<Long, List<DemandDto>> selectEsPage(DemandPageEsParam param);

    /**
     * 查询(不分页)
     *
     * @param demandPageQueryParam 参数
     * @return 结果
     */
    List<DemandDto> selectNoPage(DemandPageQueryParam demandPageQueryParam);

    /**
     * count
     *
     * @param param 请求参数
     * @return 数量
     */
    Integer count(DemandPageQueryParam param);

    /**
     * 新增
     *
     * @param demandDto
     * @return
     */
    Long insert(DemandDto demandDto);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    DemandDto findById(Long id);
    /**
     * 根据id查询需求 本地缓存
     *
     * @param id
     * @return
     */
    DemandDto findByIdWithLocal(Long id);

    /**
     * 更新
     *
     * @param demandDto
     * @return
     */
    int update(DemandDto demandDto);

    /**
     * 根据需求id删除对应的需求记录
     * @param id 需求主键id字段
     */
    void delete(Long id);

    /**
     * 根据创建人id批量修改创建人信息为当前登录用户
     * @param param 封装的参数信息
     * @return 返回受影响的行数
     */
    Integer batchUpdateOperator(DemandPageQueryParam param);

    /**
     * 保存需求
     *
     * @param demandInfoDto demand info dto
     * @return {@link Long }
     */
    Long saveOrUpdate(DemandInfoDto demandInfoDto) throws BizException;

    /**
     * 添加商品
     * @param demandId 需求ID
     * @param goodsList 商品列表
     * @return 是否添加成功
     * @throws BizException 业务异常
     */
    boolean addGoods(Long demandId, List<DemandGoodsDto> goodsList) throws BizException ;

    /**
     * 完成采购
     * @param demandId 需求ID
     * @param goodsList 商品类型
     * @return 是否成功
     */
    boolean completePurchase(Long demandId, List<DemandGoodsCompletePurchaseParam> goodsList);


    /**
     * 根据项目id查询需求信息
     *
     * @param projectIds 项目id集合
     * @return 需求信息列表
     */
    List<DemandDto> selectByProjectIds(List<Long> projectIds);

    /**
     * 根据需求名称查询需求信息
     *
     * @param name 需求名称
     * @return 需求信息列表
     */
    List<DemandDto> selectByName(String name);

    /**
     * 需求采购凭证保存或修改
     * @param param 参数
     * @return 返回结果
     */
    Boolean saveOrUpdatePurchase(DemandPurchaseRecordSaveOrUpdateParam param);

    /**
     * 需求合同关联列表-修改
     *
     * @param demandId 需求id
     * @param refList  需求合同关联
     * @return true：成功，false：失败
     * @throws BizException 修改失败
     */
    boolean contractRefModify(Long demandId, List<DemandContractRefDto> refList) throws BizException;
}

