package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.CcbCountCoinsActivityStockDto;

import java.util.List;
import java.util.Map;

/**
 * 建行数币红包库存
 *
 * @author yangyukang
 * @create 2023-09-22 20:23:15
 **/
@AdvancedFeignClient
public interface RemoteCcbCountCoinsActivityStockService {
    /**
     * 根据建行数币红包主键查询
     *
     * @param activityId 支付宝立减金ID
     * @return
     */
    CcbCountCoinsActivityStockDto selectByActivityId(Long activityId);

    /**
     * 根据建行数币红包主键批量查询
     *
     * @param activityIds 建行数币红包ID集合
     * @return key：立减金ID，value：建行数币红包库存
     */
    Map<Long, CcbCountCoinsActivityStockDto> selectByActivityIdList(List<Long> activityIds);
}
