package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandContractRefDto;

/**
 * 需求合同关联远程服务接口
 *
 * @author xuzhigang
 * @date 2025-6-3
 */
@AdvancedFeignClient
public interface RemoteDemandContractRefService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 需求合同关联信息
     */
    DemandContractRefDto selectById(Long id);

    /**
     * 根据需求ID查询
     *
     * @param demandId 需求ID
     * @return 需求合同关联信息列表
     */
    List<DemandContractRefDto> selectByDemandId(Long demandId);

    /**
     * 根据合同ID查询
     *
     * @param contractId 合同ID
     * @return 需求合同关联信息列表
     */
    List<DemandContractRefDto> selectByContractId(Long contractId);

    /**
     * 根据需求ID和合同ID查询
     *
     * @param demandId   需求ID
     * @param contractId 合同ID
     * @return 需求合同关联信息
     */
    DemandContractRefDto selectByDemandIdAndContractId(Long demandId, Long contractId);

    /**
     * 新增
     *
     * @param dto 需求合同关联信息
     * @return 执行结果
     */
    Boolean insert(DemandContractRefDto dto);

    /**
     * 批量新增
     *
     * @param dtos 需求合同关联信息列表
     * @return 执行结果
     */
    Boolean batchInsert(List<DemandContractRefDto> dtos);

    /**
     * 更新
     *
     * @param dto 需求合同关联信息
     * @return 执行结果
     */
    Boolean update(DemandContractRefDto dto);

    /**
     * 根据合同ID和多个需求ID批量查询
     *
     * @param contractId 合同ID
     * @param demandIds  需求ID列表
     * @return 需求合同关联信息列表
     */
    List<DemandContractRefDto> selectByContractIdAndDemandIds(Long contractId, List<Long> demandIds);
}
