package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同占用金额变更类型枚举
 *
 * @author xuzhigang
 * @date 2025-01-20
 */
@Getter
@AllArgsConstructor
public enum ContractOccupyAmountChangeTypeEnum {

    /**
     * 添加需求商品
     */
    ADD_DEMAND_GOODS(1, "添加需求商品"),

    /**
     * 移除需求商品
     */
    REMOVE_DEMAND_GOODS(2, "移除需求商品"),

    /**
     * 变更需求关联合同
     */
    CHANGE_DEMAND_CONTRACT_REF(3, "变更需求关联合同"),

    /**
     * 更新需求商品消耗预算
     */
    UPDATE_DEMAND_GOODS_CONSUME_BUDGET(4, "更新需求商品消耗预算"),

    /**
     * 变更需求关联合同
     */
    APPEND_DEMAND_CONTRACT_REF(5, "追加需求关联合同");

    /**
     * 类型编码
     */
    private final Integer type;

    /**
     * 类型描述
     */
    private final String desc;

    /**
     * 根据类型获取枚举
     *
     * @param type 类型
     * @return 枚举
     */
    public static ContractOccupyAmountChangeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ContractOccupyAmountChangeTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
