package cn.com.duiba.quanyi.center.api.param.qy.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 活动投放链接表
 * @author mybatis generator 
 * @date 2025-06-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ActivityPostingLinkSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17491168646426715L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 投放端链
     */
    private String linkUrl;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remark;

    /**
     * 0 模板活动旧 1 模板活动新 2 集合页旧 3集合页新 链接类型
     */
    private Integer linkType;
}