package cn.com.duiba.quanyi.center.api.remoteservice.goods.ext;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.BatchTakeResultDto;
import cn.com.duiba.quanyi.center.api.dto.goods.BatchFixGoodsOrderResultDto;
import cn.com.duiba.quanyi.center.api.param.order.BatchFixGoodsOrderParam;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderReissueParamDto;
import cn.com.duiba.quanyi.center.api.dto.goods.ext.BatchTakeParamDto;
import cn.com.duiba.quanyi.center.api.dto.goods.ext.TakeParamDto;

import java.util.List;

/**
 * 订单服务
 * @author lizhi
 * @date 2024/4/7 13:47
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderProcessorService {

    /**
     * 发放
     *
     * @param dto 发放参数
     */
    void asyncGrant(TakeParamDto dto);

    /**
     * 领取
     *
     * @param dto 领取参数
     */
    void asyncReceive(TakeParamDto dto);

    /**
     * 获取加密的key
     *
     * @param batchOrderId 批量订单ID
     * @param batchQueryOrderNo 批量订单查询单号
     * @return key
     */
    String getBatchTakeParamKey(Long batchOrderId, String batchQueryOrderNo);

    /**
     * 批量领取
     *
     * @param dto 批量领取参数
     */
    void asyncBatchReceive(BatchTakeParamDto dto);

    /**
     * 从redis中查询批量结果
     *
     * @param batchOrderNo 批量订单号
     * @param goodsBizType 商品库订单业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     * @return 结果
     */
    BatchTakeResultDto getBatchResultFromRedis(String batchOrderNo, Integer goodsBizType);

    /**
     * 关闭订单
     * 注意：该方法仅代表提交成功，具体结果，请查询订单状态
     * @param goodsOrderNo 订单号
     * @param closeReason 关闭原因
     * @return 提交关闭请求结果
     */
    BaseResultDto<Boolean> closeOrder(String goodsOrderNo, String closeReason);

    /**
     * 强制关闭订单-必须人工确认无法发成功时再调用，否则处理中订单可能会资损！！！！！
     * 注意：该方法仅代表提交成功，具体结果，请查询订单状态
     * @param goodsOrderNo 订单号
     * @param closeReason 关闭原因
     * @return 提交关闭请求结果
     */
    BaseResultDto<Boolean> forceCloseOrder(String goodsOrderNo, String closeReason);

    /**
     * 异步作废订单
     * 注意：该方法仅代表提交成功，具体结果，请查询订单状态
     * @param goodsOrderNo 订单号
     * @param cancelReason 作废原因
     * @return 提交结果
     */
    BaseResultDto<Boolean> asyncCancelOrder(String goodsOrderNo, String cancelReason);

    /**
     * 根据订单查询同一批订单
     *
     * @param goodsOrderId 订单Id
     * @return 订单列表
     * @throws BizException 异常
     */
    List<GoodsOrderDto> getGoodsOrderList(Long goodsOrderId) throws BizException;

    /**
     * 补发
     * @param dto 参数
     * @return 结果
     */
    BaseResultDto<Boolean> reissue(GoodsOrderReissueParamDto dto);

    /**
     * 批量修复订单, 如果需要，再修复完成后，执行异步发放
     *
     * @param param 参数
     */
    BaseResultDto<BatchFixGoodsOrderResultDto> batchFixGoodsOrderInfoGrantIfNeed(BatchFixGoodsOrderParam param);
}
