package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝数币红包表
 * @author 杨榆康
 * @date 2023-10-19
 */
@Data
public class AlipayCountCoinsActivityDto implements Serializable {

    private static final long serialVersionUID = -2384889848345709472L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 支付宝数币活动名称
     */
    private String countCoinsName;

    /**
     * 支付宝数币活动ID
     */
    private String alipayActId;

    /**
     * 支付宝数币活动状态
     */
    private Integer alipayActStatus;

    /**
     * 优惠立减值, 分为单位如果discount_type=single，那么就是具体的优惠立减额，比如：999代表满足一定金额减9.99元；如果是其他类型，存储JSON字符串
     */
    private Long discountValue;

    /**
     * 优惠立减门槛金额 以分为单位
     */
    private Long discountThresholdAmt;

    /**
     * 发放开始时间
     */
    private Date startTime;

    /**
     * 发放结束时间
     */
    private Date endTime;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 短链前端页面ID
     */
    private String pageId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

}
