package cn.com.duiba.quanyi.center.api.dto.workflow;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动审批流
 * @author xuzhigang
 * @date 2025-06-19
 */
@Data
public class ActivityWorkflowDto implements Serializable {

    private static final long serialVersionUID = 3847291756482936175L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 审批流类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     */
    private Integer workflowType;

    /**
     * 审批状态
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 发起人sso用户ID
     */
    private Long initiatorSsoId;

    /**
     * 活动开发sso用户ID
     */
    private Long activityDeveloperSsoId;

    /**
     * 活动产品sso用户ID
     */
    private Long activityProductManagerSsoId;
}
