package cn.com.duiba.quanyi.center.api.remoteservice.abc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.alipay.AbcAliPayCouponDto;
import cn.com.duiba.quanyi.center.api.param.alipay.AbcAliPayCouponSearchParam;

import java.util.List;

/**
 * 农总支付宝卡卷订单表
 * @author kjj mybatis generator
 * @date 2024-11-14
 */
@AdvancedFeignClient
public interface RemoteAbcAliPayCouponService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 农总支付宝卡卷订单集合
     */
    List<AbcAliPayCouponDto> selectPage(AbcAliPayCouponSearchParam param);


    /**
     * 通过客户号查询
     * @param numCif 查询条件
     * @return 农总支付宝卡卷订单集合
     */
    List<AbcAliPayCouponDto> selectByNumCf(String numCif);
    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AbcAliPayCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 农总支付宝卡卷订单
     */
    AbcAliPayCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 农总支付宝卡卷订单
     * @return 执行结果
     */
    int insert(AbcAliPayCouponDto dto);

    /**
     * 更新
     * @param dto 农总支付宝卡卷订单
     * @return 影响行数
     */
    int update(AbcAliPayCouponDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据couponId 查询唯一的数据
     * @param couponId 卡卷id
     * @return
     */
    AbcAliPayCouponDto selectByCouponId(String  couponId);
}
