package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonBlackWhiteUserMarkTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonErrorCodeEnum;
import org.apache.commons.collections4.MapUtils;

import java.util.Map;
import java.util.Objects;

/**
 *
 * @author lizhi
 * @date 2025/5/30 16:58
 */
public class ActivityCommonUtils {

    private ActivityCommonUtils() {}

    /**
     * 获取用户黑白名单用户唯一标记
     * @param whiteConf 白名单配置
     * @param blackConf 黑名单配置
     * @param userExtMap 用户扩展信息
     * @return 用户唯一标记
     * @throws BizException 配置异常时抛出异常
     */
    public static String getUserMark(ActivityCommonWhiteConfDto whiteConf, ActivityCommonBlackConfDto blackConf, Map<Integer, String> userExtMap) throws BizException {
        if (MapUtils.isEmpty(userExtMap)) {
            return null;
        }
        Integer userMarkType = getUserMarkType(whiteConf, blackConf);
        if (userMarkType == null) {
            return null;
        }
        ActivityCommonBlackWhiteUserMarkTypeEnum userMarkTypeEnum = ActivityCommonBlackWhiteUserMarkTypeEnum.getByType(userMarkType);
        if (userMarkTypeEnum == null) {
            return null;
        }
        return userExtMap.get(userMarkTypeEnum.getExtCommonKey().getCode());
    }

    /**
     * 获取黑白名单唯一标记类型
     * @param whiteConf 白名单配置
     * @param blackConf 黑名单配置
     * @return 黑白名单唯一标记类型
     * @throws BizException 异常
     */
    public static Integer getUserMarkType(ActivityCommonWhiteConfDto whiteConf, ActivityCommonBlackConfDto blackConf) throws BizException {
        Integer whiteUserMarkType = isOpenWhiteList(whiteConf) ? whiteConf.getUserMarkType() : null;
        Integer blackUserMarkType = isOpenBlackList(blackConf) ? blackConf.getUserMarkType() : null;
        if (whiteUserMarkType == null && blackUserMarkType == null) {
            return null;
        }
        if (whiteUserMarkType == null) {
            return blackUserMarkType;
        }
        if (blackUserMarkType == null) {
            return whiteUserMarkType;
        }
        if (!Objects.equals(whiteUserMarkType, blackUserMarkType)) {
            ActivityCommonErrorCodeEnum.AC000006.throwBiz();
            return null;
        }
        return whiteUserMarkType;
    }

    public static boolean isOpenWhiteList(ActivityCommonWhiteConfDto whiteConf) {
        if (whiteConf == null) {
            // 未开启
            return false;
        }
        // 未开启
        return BooleanEnum.TRUE.getCode().equals(whiteConf.getEnable());
    }

    public static boolean isOpenBlackList(ActivityCommonBlackConfDto blackConf) {
        if (blackConf == null) {
            // 未开启
            return false;
        }
        // 未开启
        return BooleanEnum.TRUE.getCode().equals(blackConf.getEnable());
    }

}
