package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayCountCoinsActivityDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AliPayCountCoinsBindGoodsSearchParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCountCoinsActivityAllocationParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCountCoinsActivityBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCountCoinsActivityPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCountCoinsActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCountCoinsBindDemandGoodsParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteAlipayCountCoinsActivityService {
    /**
     * 根据主键查询支付宝立减金
     *
     * @param id
     * @return
     */
    AlipayCountCoinsActivityDto selectById(Long id);

    /**
     * 根据支付宝活动id查询支付宝立减金
     *
     * @param alipayActId 支付宝活动id
     * @return
     */
    AlipayCountCoinsActivityDto selectByActId(String alipayActId);

    /**
     * 根据批次号或者券模板id查询
     *
     * @param actId 批次号
     * @param templateId 券模板id
     * @return 建行数币红包
     */
    AlipayCountCoinsActivityDto selectByActIdOrTemplateId(String actId,String templateId);

    /**
     * 根据支付宝立减金活动id批量查询
     *
     * @param activityIds 活动id
     * @return 支付宝立减金
     */
    List<AlipayCountCoinsActivityDto> selectByActIds(Set<String> activityIds);

    /**
     * 根据id批量查询
     *
     * @param idList
     * @return
     */
    Map<Long, AlipayCountCoinsActivityDto> selectByIdList(Set<Long> idList);

    /**
     * 根据需求ID查询
     *
     * @param demandId
     * @return
     */
    List<AlipayCountCoinsActivityDto> selectByDemandId(Long demandId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandId
     * @param skuId
     * @return
     */
    List<AlipayCountCoinsActivityDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandGoodsId
     * @param skuId
     * @return
     */
    List<AlipayCountCoinsActivityDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<AlipayCountCoinsActivityDto> selectPage(AlipayCountCoinsActivityPageParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(AlipayCountCoinsActivityPageParam param);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(AlipayCountCoinsActivitySaveOrUpdateParam param);

    /**
     * 批次分配
     *
     * @param param 参数
     * @return 主键id
     */
    Long allocation(AlipayCountCoinsActivityAllocationParam param);

    /**
     * 绑定到需求商品
     *
     * @return
     */
    int bindDemandGoods(AlipayCountCoinsBindDemandGoodsParam param);

    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<AlipayCountCoinsBindDemandGoodsParam> list);

    /**
     * 解除绑定
     *
     * @return
     */
    int unbindDemandGoods(Long id, Long demandGoodsId);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId
     * @return
     */
    List<AlipayCountCoinsActivityDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(AlipayCountCoinsActivityBatchUpdateCreatorParam param);

    /**
     * 查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 数量
     */
    long selectCreatorCount(Long createOperatorId);

    /**
     * 需求商品关联批次-查询支付宝数币红包 数量
     * 聚宝盆发放的批次-需校验面额、非聚宝盆发放的-无需校验面额
     * @param param 请求参数
     * @return 数币红包数量
     */
    long selectBindDemandGoodsCoinsCount(AliPayCountCoinsBindGoodsSearchParam param);

    /**
     * 需求商品关联批次-查询支付宝数币红包
     * 聚宝盆发放的批次-需校验面额、非聚宝盆发放的-无需校验面额
     * @param param 请求参数
     * @return 数币红包列表
     */
    List<AlipayCountCoinsActivityDto> selectBindDemandGoodsCoinsPage(AliPayCountCoinsBindGoodsSearchParam param);
}
