package cn.com.duiba.quanyi.center.api.enums.warn;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yinjiaqi
 * @date 2025-06-04 14:40:35
 */
@Getter
@AllArgsConstructor
public enum DingDingWarnTypeEnum {
    /**
     * 活动库存不足
     */
    ACTIVITY_STOCK_INSUFFICIENT(1, "活动库存不足"),

    /**
     * 批次库存不足
     */
    BATCH_STOCK_INSUFFICIENT(2, "批次库存不足"),

    /**
     * 批次即将到期
     */
    BATCH_NEAR_EXPIRY(3, "批次即将到期"),

    /**
     * 商户余额不足
     */
    MERCHANT_BALANCE_INSUFFICIENT(4, "商户余额不足"),

    /**
     * 批次创建失败
     */
    BATCH_CREATION_FAILED(5, "批次创建失败");

    private final Integer code;
    private final String desc;
}

