package cn.com.duiba.quanyi.center.api.param.contract;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 合同消耗明细分页查询参数
 *
 * @author xuzhigang
 * @date 2025-06-05
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ContractConsumeDetailPageQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 4829571639284756291L;

    /**
     * 需求id tb_demand.id
     */
    private Long demandId;

    /**
     * 合同id tb_contract.id
     */
    private Long contractId;

    /**
     * 需求创建时间
     */
    private Date demandCreateDate;

    /**
     * 需求创建时间开始
     */
    private Date demandCreateDateStart;

    /**
     * 需求创建时间结束
     */
    private Date demandCreateDateEnd;

    /**
     * 需求创建ssoId
     */
    private String demandCreatorSsoId;

    /**
     * 是否超额 0-未超额 1-超额
     */
    private Integer hasOverAmount;

    /**
     * 排序类型 1-根据超出金额升序 2-根据超出金额降序
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractConsumeDetailSortTypeEnum
     */
    private Integer sortType;
}