package cn.com.duiba.quanyi.center.api.param.demand;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/5/30 17:31
 **/
@Data
public class DemandGoodsUpdateConsumeBudgetParam implements Serializable {
    private static final long serialVersionUID = 69588466937551925L;

    /**
     * 需求商品ID
     */
    private Long id;

    /**
     * 修改前消耗预算
     */
    private Long originConsumeBudget;

    /**
     * 修改后消耗预算
     */
    private Long consumeBudget;

    /**
     * 计算后的商品数量（仅固定面额商品需要）
     */
    private Long quantity;

    /**
     * 修改后消耗预算（计算服务费）
     */
    private Long consumeBudgetWithFee;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;
}
