package cn.com.duiba.quanyi.center.api.param.workflow;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 需求审批流发起审批参数
 * @author xuzhigang
 * @date 2025-07-07
 */
@Data
public class DemandWorkflowStartApprovalProcessParam implements Serializable {

    private static final long serialVersionUID = 8472639184756291847L;

    /**
     * 需求变更记录ID
     */
    @NotNull(message = "需求变更记录ID不能为空")
    private Long demandChangeRecordId;

    /**
     * 当前用户部门ID
     */
    @NotNull(message = "部门ID不能为空")
    private Long deptId;

    /**
     * 发起人用户ID
     */
    @NotNull(message = "发起人用户ID不能为空")
    private String originatorUserId;

    /**
     * 发起人sso用户ID
     */
    @NotNull(message = "发起人sso用户ID不能为空")
    private Long initiatorSsoId;
}
