package cn.com.duiba.quanyi.center.api.dto.equity.coupon;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/8/8 14:39
 */
@Data
public class PayEquityCouponDto implements Serializable {
    
    private static final long serialVersionUID = -3021924973010987993L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 券唯一编码
     */
    private String couponCode;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动奖品ID
     */
    private Long prizeId;

    /**
     * 服务编码
     */
    private String dbCode;

    /**
     * 需要支付的金额，单位分
     */
    private Long payAmount;

    /**
     * 是否限定车牌号
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer limitCarNumber;

    /**
     * 车牌号
     */
    private String carNumber;
    
    
}
