package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentInfoPrepaymentRefDto;

import java.util.List;
import java.util.Set;

/**
 * 付款-预付款退款-关联信息
 * @author kjj mybatis generator
 * @date 2025-08-28
 */
@AdvancedFeignClient
public interface RemotePaymentInfoPrepaymentRefService {

    /**
     * 根据付款ID查询
     * @param paymentId 付款ID
     * @return 列表
     */
    List<PaymentInfoPrepaymentRefDto> selectByPaymentId(Long paymentId);

    /**
     * 根据付款ID查询
     * @param paymentId 付款ID
     * @param refType 关联类型
     * @see cn.com.duiba.quanyi.center.api.enums.payment.PaymentInfoPrepaymentRefEnum
     * @return 列表
     */
    List<PaymentInfoPrepaymentRefDto> selectByPaymentIdAndRefType(Long paymentId, Integer refType);

    /**
     * 根据付款ID查询
     * @param paymentIds 付款ID
     * @return 列表
     */
    List<PaymentInfoPrepaymentRefDto> selectByPaymentIds(Set<Long> paymentIds);

    /**
     * 根据付款ID查询
     * @param paymentIds 付款ID
     * @param refType 关联类型
     * @see cn.com.duiba.quanyi.center.api.enums.payment.PaymentInfoPrepaymentRefEnum
     * @return 列表
     */
    List<PaymentInfoPrepaymentRefDto> selectByPaymentIdsType(Set<Long> paymentIds, Integer refType);

    /**
     * 根据关联ID查询锁定状态的关联关系
     * @param refIds 关联ID
     * @param refType 关联类型
     * @see cn.com.duiba.quanyi.center.api.enums.payment.PaymentInfoPrepaymentRefEnum
     * @return 列表
     */
    List<PaymentInfoPrepaymentRefDto> selectLockListByRef(List<Long> refIds, Integer refType);
}
