package cn.com.duiba.quanyi.center.api.remoteservice.settlement.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.task.SettlementStatTaskRefDto;
import cn.com.duiba.quanyi.center.api.param.settlement.task.SettlementStatTaskRefSearchParam;
import java.util.List;

/**
 * 任务与统计关系表
 * @author kjj mybatis generator
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementStatTaskRefService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 任务与统计关系集合
     */
    List<SettlementStatTaskRefDto> selectPage(SettlementStatTaskRefSearchParam param);

    /**
     * 根据统计ID、统计ID类型、任务类型查询
     * @param statIds 统计ID
     * @param statIdType 统计ID类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatIdTypeEnum
     * @param taskType 任务类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTaskTypeEnum
     * @return 任务与统计关系集合
     */
    List<SettlementStatTaskRefDto> selectByStatIdAndType(List<Long> statIds, Integer statIdType, Integer taskType);

    /**
     * 批量新增
     * @param list 任务与统计关系
     * @return 执行结果
     */
    int batchInsert(List<SettlementStatTaskRefDto> list);
}
