package cn.com.duiba.quanyi.center.api.param.mall.goods;

import cn.com.duiba.quanyi.center.api.dto.activity.CouponExpireTypeDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商品更新参数
 * @author xuzhigang
 * @date 2024/05/28
 */
@Data
public class MallGoodsUpdateParam implements Serializable {

    private static final long serialVersionUID = -4408906588496669717L;
    /**
     * ID
     */
    private Long id;

    /**
     * 商品名称
     */
    private String mallSpuName;

    /**
     * 商品缩略图
     */
    private String mainImgs;

    /**
     * 商品主图地址，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 图文详情
     */
    private String spuDesc;

    /**
     * 领取方式
     */
    private Integer grantType;

    /**
     * sku列表
     */
    private List<MallGoodsSkuUpdateParam> skuList;

    /**
     * 短链过期dto
     */
    private CouponExpireTypeDto couponExpireTypeDto;

    /**
     * 创建人id
     */
    private Long creatorId;

    /**
     * 创建人名称
     */
    private String creatorName;
}
