package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/9/6 15:02
 **/
@Getter
@AllArgsConstructor
public enum SceneLimitTypeEnum {
    NOT_LIMIT(1, "不限制"),
    LIMIT(2, "限制");

    private final Integer type;

    private final String desc;

    public static SceneLimitTypeEnum getByType(Integer type) {
        for (SceneLimitTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
