package cn.com.duiba.quanyi.center.api.remoteservice.refund;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.refund.RefundTaskDetailDto;
import cn.com.duiba.quanyi.center.api.param.refund.RefundTaskDetailPageQueryParam;

/**
 * 退款执行明细远程服务接口
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@AdvancedFeignClient
public interface RemoteRefundTaskDetailService {

    /**
     * 分页查询退款任务明细
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<RefundTaskDetailDto> selectPage(RefundTaskDetailPageQueryParam param);

    /**
     * 根据条件查询总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    long selectCount(RefundTaskDetailPageQueryParam param);

    /**
     * 根据ID查询退款任务明细
     *
     * @param id 主键ID
     * @return 退款任务明细
     */
    RefundTaskDetailDto selectById(Long id);

    /**
     * 根据支付业务单号查询
     *
     * @param paymentOrderNo 支付业务单号
     * @return 退款任务明细
     */
    RefundTaskDetailDto selectByPaymentOrderNo(String paymentOrderNo);

    /**
     * 根据扫描任务ID查询明细列表
     *
     * @param scanTaskId 扫描任务ID
     * @return 退款任务明细列表
     */
    List<RefundTaskDetailDto> selectByScanTaskId(Long scanTaskId);

    /**
     * 根据扫描任务ID集合查询明细列表
     *
     * @param scanTaskIds 扫描任务ID集合
     * @return 退款任务明细列表
     */
    List<RefundTaskDetailDto> selectByScanTaskIds(List<Long> scanTaskIds);

    /**
     * 插入退款任务明细
     *
     * @param dto 退款任务明细DTO
     * @return 影响行数
     */
    int insert(RefundTaskDetailDto dto);

    /**
     * 批量插入退款任务明细
     *
     * @param list 退款任务明细DTO列表
     * @return 影响行数
     */
    int batchInsert(List<RefundTaskDetailDto> list);
}
