package cn.com.duiba.quanyi.center.api.remoteservice.qy.bank.zgbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bank.zgbank.ZgbankRitUseOrderDto;
import cn.com.duiba.quanyi.center.api.param.bank.zgbank.ZgbankRitUseOrderSearchParam;
import java.util.List;

/**
 * 中国银行使用订单信息表
 * @author kjj mybatis generator
 * @date 2025-06-23
 */
@AdvancedFeignClient
public interface RemoteZgbankRitUseOrderService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 中国银行使用订单信息集合
     */
    List<ZgbankRitUseOrderDto> selectPage(ZgbankRitUseOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ZgbankRitUseOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中国银行使用订单信息
     */
    ZgbankRitUseOrderDto selectById(Long id);

    /**
     * 新增
     * @param dto 中国银行使用订单信息
     * @return 执行结果
     */
    int insert(ZgbankRitUseOrderDto dto);

    /**
     * 更新
     * @param dto 中国银行使用订单信息
     * @return 影响行数
     */
    int update(ZgbankRitUseOrderDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据rightEntNo查询
     * @param rightEntNo
     * @return
     */
    ZgbankRitUseOrderDto selectByRightEntNo(String rightEntNo);
}
