package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.OfficialAccountDto;

/**
 * 公众账号
 * @author lizhi
 * @date 2023/5/16 11:34 AM
 */
@AdvancedFeignClient
public interface RemoteOfficialAccountService {

    /**
     * 根据业务类型查询优先级最大的公众账号
     * @param bizType 业务类型
     *                {@link cn.com.duiba.quanyi.center.api.enums.user.OaBizTypeEnum}
     * @return 公众账号配置
     */
    OfficialAccountDto selectMaxPayLoadByBizType(Integer bizType);

    /**
     * 根据公众账号ID
     * @param appId 公众账号ID
     * @return 公众账号配置
     */
    OfficialAccountDto selectByAppId(String appId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 公众账号配置
     */
    OfficialAccountDto selectById(Long id);
}
