package cn.com.duiba.quanyi.center.api.utils;

import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/5/8 18:17
 */
@Slf4j
public class CaffeineUtils {
    
    private CaffeineUtils() {}

    public static <K, V> Map<K, V> selectMapWithLocal(String biz, LoadingCache<K, V> cache, Set<K> cacheKeys, Function<Set<K>, Map<K, V>> loadFunc) {
        Map<@NonNull K, @NonNull V> allPresent = cache.getAllPresent(cacheKeys);
        if (MapUtils.isEmpty(allPresent)) {
            allPresent = new HashMap<>();
        }
        // 将本地缓存没有的，放入本地缓存和 allPresent
        return putNoCache(biz, cache, cacheKeys, allPresent, loadFunc);
    }

    public static <K, V, K1, V1> Map<K1, V1> convertMap(Map<K, V> cacheMap, Function<K, K1> keyFunc, Function<V, V1> valFunc) {
        return cacheMap.entrySet().stream().filter(entry -> valFunc.apply(entry.getValue()) != null).collect(Collectors.toMap(entry -> keyFunc.apply(entry.getKey()), entry -> valFunc.apply(entry.getValue()), (v1, v2) -> v2));
    }


    private static <K, V> Map<@NonNull K, @NonNull V> putNoCache(String biz, LoadingCache<K, V> cache, Set<K> cacheKeys, Map<@NonNull K, @NonNull V> allPresent, Function<Set<K>, Map<K, V>> loadFunc) {
        Set<K> noCacheKeys = cacheKeys.stream().filter(cacheKey -> !allPresent.containsKey(cacheKey)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(noCacheKeys)) {
            return allPresent;
        }
        Map<K, V> loadMap = loadFunc.apply(noCacheKeys);
        if (MapUtils.isEmpty(loadMap)) {
            log.warn("[{}], 批量查询未查询到, cacheKeys={}", biz, JSON.toJSONString(cacheKeys));
            return allPresent;
        }
        Map<@NonNull K, @NonNull V> resultMap = new HashMap<>(allPresent);
        if (loadMap.size() != noCacheKeys.size()) {
            log.warn("[{}], 批量查询部分未查询到, cacheKeys={}, loadMap.size={}", biz, JSON.toJSONString(cacheKeys), loadMap.size());
        }
        loadMap.forEach((key, value) -> {
            cache.put(key, value);
            resultMap.put(key, value);
        });
        return resultMap;
    }
}
