package cn.com.duiba.quanyi.center.api.param.pay;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付订单领取凭证
 * @author mybatis generator 
 * @date 2025-04-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PayOrderTakeVoucherSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17446989970495782L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 支付单号
     */
    private String bizOrderNo;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 领取类型：1-可领一次，2-可领多次
     */
    private Integer takeType;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 已领取次数
     */
    private Long takeCount;

    /**
     * 领取记录ID，英文逗号分隔
     */
    private String recordIds;
}