package cn.com.duiba.quanyi.center.api.enums.payment;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/9/18 15:50
 **/
@Getter
@AllArgsConstructor
public enum PrepaymentStatusEnum {
    // 状态 1-待付款 2-发起中（待提交） 3-付款中（审批中） 4-待抵扣（审批通过） 5-审批拒绝 6-部分抵扣 7-已抵扣
    WAIT_PAY(1, "待付款"),
    INITIALIZING(2, "发起中"),
    PAYING(3, "付款中"),
    WAIT_DEDUCTION(4, "待抵扣"),
    REJECTED(5, "审批拒绝"),
    PARTIAL_DEDUCTION(6, "部分抵扣"),
    DEDUCTION(7, "已抵扣");

    private final Integer status;

    private final String desc;
}
