package cn.com.duiba.quanyi.center.api.dto.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 打款申请-供应商预付款
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@Data
public class PaymentInfoSupplierPrepaymentDto implements Serializable {
     
    private static final long serialVersionUID = 17345671234567894L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 预付款名称
     */
    private String prepaymentName;

    /**
     * 总金额
     */
    private Long paymentAmount;

    /**
     * 实际付款金额
     */
    private Long actualPaymentAmount;

    /**
     * 已抵扣金额
     */
    private Long deductionAmount;

    /**
     * 状态
     */
    private Integer prepaymentStatus;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 申请附件
     */
    private String applyAttachment;

    /**
     * 备注
     */
    private String remark;

    /**
     * 付款ID
     */
    private Long paymentId;
}
