package cn.com.duiba.quanyi.center.api.dto.refund;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 退款变更记录DTO
 *
 * @author yangyukang
 * @date 2025/1/21
 */
@Data
public class RefundChangeRecordDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 退款总金额，单位为分
     */
    private Long totalRefundAmount;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 文件URL
     */
    private String fileUrl;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 上传任务ID
     */
    private Long uploadTaskId;

    /**
     * 审批状态
     */
    private Integer approvalStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 操作人sso用户ID
     */
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    private String operatorSsoName;

    /**
     * 审批流程实例ID
     */
    private Long workflowInstanceId;

    /**
     * 钉钉用户ID
     */
    private String dingTalkUserId;

    /**
     * 钉钉部门ID
     */
    private Long dingTalkDeptId;

    /**
     * 变更参数JSON
     */
    private String changeParam;

    /**
     * 变更记录明细
     */
    private String changeRecordDetail;
}
