package cn.com.duiba.quanyi.center.api.dto.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商付款
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@Data
public class PaymentInfoSupplierDto implements Serializable {
     
    private static final long serialVersionUID = 17345671234567896L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 供应商付款编号
     */
    private String supplierPaymentNo;

    /**
     * 状态
     */
    private Integer paymentStatus;

    /**
     * 审批发起时间
     */
    private Date approvalStartTime;

    /**
     * 审批结束时间
     */
    private Date approvalEndTime;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 付款ID
     */
    private Long paymentId;

    /**
     * 抵扣金额
     */
    private Long deductionAmount;

    /**
     * 锁定版本
     */
    private Integer lockVersion;
}
