package cn.com.duiba.quanyi.center.api.utils;

import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderDto;
import cn.com.duiba.quanyi.center.api.enums.activity.BatchTakeStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum;
import lombok.extern.slf4j.Slf4j;

/**
 * @author lizhi
 * @date 2024/4/2 17:22
 */
@Slf4j
public class BatchTakeOrderNoUtils {
    
    private BatchTakeOrderNoUtils() {}
    
    public static String getBatchQueryOrderNo(String batchOrderNo, Integer goodsBizType) {
        return batchOrderNo + QuanYiStringUtils.toStringAndAddZero(goodsBizType.toString(), 2);
    }
    
    public static Pair<String, Integer> parseBatchQueryOrderNo(String batchQueryOrderNo) {
        return Pair.of(parseBatchOrderNo(batchQueryOrderNo), parseGoodsBizType(batchQueryOrderNo));
    }

    private static String parseBatchOrderNo(String batchQueryOrderNo) {
        try {
            return batchQueryOrderNo.substring(0, batchQueryOrderNo.length() - 2);
        } catch (Exception e) {
            log.error("[BatchTake], parse batchOrderNo error, batchQueryOrderNo={}", batchQueryOrderNo, e);
            return null;
        }
    }

    private static Integer parseGoodsBizType(String batchQueryOrderNo) {
        try {
            String typeStr = batchQueryOrderNo.substring(batchQueryOrderNo.length() - 2);
            return Integer.parseInt(typeStr);
        } catch (Exception e) {
            log.error("[BatchTake], parse goodsBizType error, batchQueryOrderNo={}", batchQueryOrderNo, e);
            return null;
        }
    }

    /**
     * 获取领取状态（批量领取、短链接领取）
     * @param goodsOrderList
     * @return
     */
    public static BatchTakeStatusEnum getTakeStatus(List<GoodsOrderDto> goodsOrderList) {
        if (CollectionUtils.isEmpty(goodsOrderList)) {
            return BatchTakeStatusEnum.INIT;
        }
        int success = 0;
        int fail = 0;
        int process = 0;
        int notReceive = 0;
        int shortFail = 0;
        int shortProcess = 0;
        int objectProcess = 0;
        for (GoodsOrderDto dto : goodsOrderList) {
            if (GoodsOrderStatusEnum.PROCESS.getStatus().equals(dto.getOrderStatus())) {
                process++;
            } else if (GoodsOrderStatusEnum.SHORT_URL_RECEIVE_PROCESS.getStatus().equals(dto.getOrderStatus())) {
                shortProcess++;
            } else if (isFail(dto.getOrderStatus())) {
                fail++;
            } else if (isShortFail(dto.getOrderStatus())) {
                shortFail++;
            } else if (GoodsOrderStatusEnum.NOT_RECEIVE.getStatus().equals(dto.getOrderStatus())) {
                notReceive++;
            } else if(isObjectProcess(dto.getOrderStatus())){
                objectProcess++;
            } else {
                success++;
            }
        }
        if (success == goodsOrderList.size()) {
            return BatchTakeStatusEnum.ALL_SUCCESS;
        }
        if (fail == goodsOrderList.size()) {
            return BatchTakeStatusEnum.ALL_FAIL;
        }
        if (objectProcess == goodsOrderList.size()){
            return BatchTakeStatusEnum.OBJECT_SUCCESS;
        }
        if (objectProcess > 0){
            return BatchTakeStatusEnum.OBJECT_PART_SUCCESS;
        }
        if (shortFail == goodsOrderList.size()) {
            return BatchTakeStatusEnum.SHORT_URL_ALL_FAIL;
        }
        if (notReceive == goodsOrderList.size()) {
            return BatchTakeStatusEnum.SHORT_URL_INIT;
        }
        if (fail + shortFail == goodsOrderList.size()) {
            return BatchTakeStatusEnum.SHORT_URL_ALL_FAIL;
        }
        if (success + notReceive == goodsOrderList.size()) {
            return BatchTakeStatusEnum.SHORT_URL_PROCESSING;
        }
        if (shortProcess > 0) {
            return BatchTakeStatusEnum.SHORT_URL_PROCESSING;
        }
        if (shortFail > 0) {
            return BatchTakeStatusEnum.SHORT_URL_PART_FAIL;
        }
        if (process > 0) {
            return BatchTakeStatusEnum.PROCESSING;
        }
        if (fail > 0) {
            return BatchTakeStatusEnum.PART_FAIL;
        }
        log.warn("[BatchTake], status error, goodsOrderList={}", JSON.toJSONString(goodsOrderList));
        return BatchTakeStatusEnum.PROCESSING;
    }


    private static boolean isFail(Integer status) {
        return GoodsOrderStatusEnum.FAIL.getStatus().equals(status) 
                || GoodsOrderStatusEnum.EXCEPTION.getStatus().equals(status)
                || GoodsOrderStatusEnum.FAIL_CAN_RETRY.getStatus().equals(status);
    }
    
    private static boolean isShortFail(Integer status) {
        return GoodsOrderStatusEnum.SHORT_URL_RECEIVE_FAIL.getStatus().equals(status) 
                || GoodsOrderStatusEnum.SHORT_URL_RECEIVE_FAIL_CAN_RETRY.getStatus().equals(status)
                || GoodsOrderStatusEnum.SHORT_URL_RECEIVE_EXCEPTION.getStatus().equals(status);
    }


    private static boolean isObjectProcess(Integer status){
        return GoodsOrderStatusEnum.UNSHIPPED.getStatus().equals(status)
                || GoodsOrderStatusEnum.SHIPPED.getStatus().equals(status)
                || GoodsOrderStatusEnum.COMPLETED.getStatus().equals(status)
                || GoodsOrderStatusEnum.CANCELED.getStatus().equals(status)
                || GoodsOrderStatusEnum.RETURNED.getStatus().equals(status);

    }

}
