package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiOrderActivityDto;

/**
 * API订单-活动扩展信息
 * @author kjj mybatis generator 
 * @date 2024-07-03
 */
@AdvancedFeignClient
public interface RemoteApiOrderActivityService {

    /**
     * 新增或更新
     *
     * @param dto 订单内容
     * @return 主键
     */
    Long saveOrUpdate(ApiOrderActivityDto dto);

    /**
     * 根据三方单号查询
     * 
     * @param thirdOrderId 三方订单号
     * @param apiJointId 对接ID
     * @return API订单-活动扩展信息
     */
    ApiOrderActivityDto selectByThird(String thirdOrderId, Long apiJointId);
}