package cn.com.duiba.quanyi.center.api.param.payment;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/9/24 17:25
 **/
@Data
public class SupplierPrepaymentApplyPaymentParam implements Serializable {
    private static final long serialVersionUID = -3600054274959066279L;

    /**
     * 预付款id
     */
    private Long prepaymentId;

    /**
     * 付款公司-选项ID
     */
    private Long paymentCompanyOptionsId;

    /**
     * 付款公司
     */
    private String paymentCompany;

    /**
     * 收款账户
     */
    private String receivingAccount;

    /**
     * 开户行
     */
    private String openingBank;

    /**
     * 付款事由
     */
    private String paymentReason;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 付款方式
     */
    private String paymentType;

    /**
     * 货币类型选项ID
     */
    private Long currencyOptionsId;

    /**
     * 货币类型
     */
    private String currency;

    /**
     * 是否已收到发票 0-否 1-是
     */
    private Integer invoiceReceived;

    /**
     * 未收到原因
     */
    private String nonReceiptReason;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 创建人ID（ssoId）
     */
    private Long createOperatorId;

    /**
     * 创建人姓名（ssoName）
     */
    private String createOperatorName;

    /**
     * 付款方式-选项ID
     */
    private Long paymentTypeOptionsId;
}
