package cn.com.duiba.quanyi.center.api.dto.settlement.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单统计数据处理任务表
 * @author mybatis generator
 * @date 2024-11-30
 */
@Data
public class SettlementStatTaskMqDto implements Serializable {

    private static final long serialVersionUID = 17329512198841201L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 发票与结算单关联关系
     */
    private Long invoiceSettlementRefId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 发票ID/回款ID
     */
    private Long bizId;

    /**
     * 关联任务ID，退回金额时使用
     */
    private Long refTaskId;

    /**
     * 本次总金额
     */
    private Long totalAmount;

    /**
     * 已处理金额
     */
    private Long dealAmount;

    /**
     * 需求已处理金额
     */
    private Long demandDealAmount;

    /**
     * 合同已处理金额
     */
    private Long contractDealAmount;

    /**
     * 任务类型：1-开票，2-发票红冲，3-发票移除，4-回款认领，5-回款取消认领
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTaskTypeEnum
     */
    private Integer taskType;
}
