package cn.com.duiba.quanyi.center.api.param.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2025/9/26 17:14
 **/
@Data
public class SupplierPaymentSaveParam implements Serializable {
    private static final long serialVersionUID = 8317405982807669937L;

    /**
     * 付款公司-选项ID
     */
    private Long paymentCompanyOptionsId;

    /**
     * 付款公司
     */
    private String paymentCompany;

    /**
     * 收款账户
     */
    private String receivingAccount;

    /**
     * 开户行
     */
    private String openingBank;

    /**
     * 付款事由
     */
    private String paymentReason;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 付款方式
     */
    private String paymentType;

    /**
     * 付款方式-选项ID
     */
    private Long paymentTypeOptionsId;

    /**
     * 货币类型选项ID
     */
    private Long currencyOptionsId;

    /**
     * 货币类型
     */
    private String currency;

    /**
     * 是否已收到发票 0-否 1-是
     */
    private Integer invoiceReceived;

    /**
     * 未收到原因
     */
    private String nonReceiptReason;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 入库单
     */
    private List<SupplierPaymentInboundOrderParam> inboundOrderList;

    /**
     * 预付款抵扣信息
     */
    private List<SupplierPrepaymentDeductionParam> prepaymentDeductionList;
}
