package cn.com.duiba.quanyi.center.api.remoteservice.insurance.car;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.car.CarInsuranceSettlementMaterialsDto;
import cn.com.duiba.quanyi.center.api.param.insurance.car.CarInsuranceSettlementMaterialsSearchParam;
import java.util.List;

/**
 * 车险结算材料
 * @author kjj mybatis generator 
 * @date 2025-03-07
 */
@AdvancedFeignClient
public interface RemoteCarInsuranceSettlementMaterialsService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 车险结算材料集合
     */
    List<CarInsuranceSettlementMaterialsDto> selectPage(CarInsuranceSettlementMaterialsSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CarInsuranceSettlementMaterialsSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 车险结算材料
     */
    CarInsuranceSettlementMaterialsDto selectById(Long id);

    /**
     * 新增
     * @param dto 车险结算材料
     * @return 主键
     */
    Long insert(CarInsuranceSettlementMaterialsDto dto);

    /**
     * 更新
     * @param dto 车险结算材料
     * @return 影响行数
     */
    int update(CarInsuranceSettlementMaterialsDto dto);
}