package cn.com.duiba.quanyi.center.api.dto.payment;

import lombok.Data;

import java.io.Serializable;

/**
 * 供应商付款记录与入库单关联关系简化DTO
 * @author xuzhigang
 * @date 2025-10-10 15:30
 */
@Data
public class PaymentInfoSupplierInboundSimpleDto implements Serializable {

    private static final long serialVersionUID = 2347891256734512389L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 供应商付款ID
     */
    private Long supplierPaymentId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 入库单ID
     */
    private Long inboundOrderId;

    /**
     * 申请付款金额
     */
    private Long applyPaymentAmount;
}

