package cn.com.duiba.quanyi.center.api.param.payment;

import cn.com.duiba.quanyi.center.api.enums.payment.PaymentPrepaymentRefundMethodEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 打款申请-预付款退款
 * @author mybatis generator
 * @date 2025-08-28
 */
@Data
public class PaymentInfoPrepaymentSaveParam implements Serializable {

    private static final long serialVersionUID = 1756361311550465L;

    /**
     * 付款事由
     */
    private String paymentReason;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 打款公司-选项ID
     */
    private Long paymentCompanyOptionsId;

    /**
     * 打款公司
     */
    private String paymentCompany;

    /**
     * 付款方式-选项ID
     */
    private Long paymentTypeOptionsId;

    /**
     * 付款方式
     */
    private String paymentType;

    /**
     * 收款账户
     */
    private String receivingAccount;

    /**
     * 收款公司
     */
    private String receivingCompany;

    /**
     * 开户行
     */
    private String openingBank;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 申请附件
     */
    private String applyAttachment;

    /**
     * 货币类型选项ID
     */
    private Long currencyOptionsId;

    /**
     * 货币类型
     */
    private String currency;

    /**
     * 付款类型，1-垫资打款，2-预付款退款，3-保证金
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PaymentPurposeEnum
     */
    private Integer paymentPurpose;

    /**
     * 打款日期：日期，必填
     */
    private Date paymentDate;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 退款方式：1-关联负票，2-不关联负票
     * @see PaymentPrepaymentRefundMethodEnum
     */
    private Integer refundMethod;

    /**
     * 关联发票
     */
    private List<Long> invoiceIdList;
}
