package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.KvDataDto;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityKvEnum;
import cn.com.duiba.quanyi.center.api.param.activity.KvDataVoSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * KV数据表
 * @author kjj mybatis generator
 * @date 2024-06-20
 */
@AdvancedFeignClient
public interface RemoteKvDataService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return KV数据集合
     */
    List<KvDataDto> selectPage(KvDataVoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(KvDataVoSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return KV数据
     */
    KvDataDto selectById(Long id);

    /**
     * 新增
     * @param dto KV数据
     * @return 执行结果
     */
    Long insert(KvDataDto dto);

    /**
     * 更新
     * @param dto KV数据
     * @return 影响行数
     */
    int update(KvDataDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新StringValue 存在则更新 不存在则新增
     * @see ActivityKvEnum
     * @param key 唯一key
     * @param value 值
     * @param expire 过期时间
     * @param isRefresh true 刷新过期时间  false 不刷新
     */
    boolean setStringValue(String key, String value, Long expire, boolean isRefresh);


    /**
     * 查询数据
     *
     * @param key 唯一key
     * @return 数据结果
     */
     KvDataDto get(String key);

    /**
     * 批量查询
     *
     * @param keys 批量查询key
     * @return 结果集合
     */
    Map<String, KvDataDto> multiGet(List<String> keys);
    /**
     * 批量查询
     *
     * @param keys 批量查询key
     * @return 结果集合
     */
    Map<String, String> multiGetString(List<String> keys);

    /**
     * 批量插入 主键冲突会覆盖 使用需要考虑并发
     * @param dtoList dto集合
     * @return 插入结果
     */
    boolean multiSet(List<KvDataDto> dtoList);

    /**
     *
     * @param key 键
     * @return 如果值存在且尚未过期，返回对应值；否则返回{@code null}
     */
    Long getLong(String key);

    /**
     * 批量获取{@code Long}类型的值，如果某个键不存在，将使用{@code null}填充value值
     *
     * @param keys 键组成的列表
     * @return 如果value值存在且尚未过期，目标位置为对应值；否则目标位置为{@code null}
     */
    Map<String, Long> multiGetLongNew(List<String> keys);

    /**
     * 增加/减少数值
     * @param key
     * @param offset 增量
     * @param max  限制
     * @param expire 失效时间
     * @param replaceExpireIfAbsent  当记录已存在时，为true表示刷新时间，为false表示沿用旧时间
     * @return 是否更新成功
     */
    boolean increase(String key, long offset, Long max, Date expire, boolean replaceExpireIfAbsent);

    /**
     * 批量获取{@code Long}类型的值，如果某个键不存在，将使用{@code null}填充value值
     *
     * @param keys 键组成的列表
     * @return 如果value值存在且尚未过期，目标位置为对应值；否则目标位置为{@code null}
     */
    Map<String, Long> multiGetLongByKeyAndValue(List<String> keys,String value);
    /**
     * 根据key和value 增加/减少数值
     * @param key
     * @param offset 增量
     * @param max  限制
     * @param expire 失效时间
     * @param replaceExpireIfAbsent  当记录已存在时，为true表示刷新时间，为false表示沿用旧时间
     * @return 是否更新成功
     */
    boolean increaseByValue(String key, long offset, Long max, Date expire, boolean replaceExpireIfAbsent,String value);
}
