package cn.com.duiba.quanyi.center.api.dto.boc.szbl;

import lombok.Data;

import java.io.Serializable;

/**
 * 深圳中行活动便利仓基础响应DTO
 * @author cxw
 * @date 2025/01/20
 */
@Data
public class BocSzBlBaseDto implements Serializable {

    private static final long serialVersionUID = -2895377627323738850L;
    /**
     * 秘钥密文 - 由发送方使用接收方公钥加密SM4秘钥得到
     */
    private String cipherkey;

    /**
     * 数据密文 - 由发送方使用SM4秘钥加密数据明文得到
     */
    private String ciphertext;

    /**
     * 数据签名 - 由发送方使用己方私钥加密数据明文得到
     */
    private String sign;

    public BocSzBlBaseDto() {
    }

    public BocSzBlBaseDto(String cipherkey, String ciphertext, String sign) {
        this.cipherkey = cipherkey;
        this.ciphertext = ciphertext;
        this.sign = sign;
    }
}