package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2025/5/12 15:04
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonUserResultCanTakeDto extends ActivityCommonCanParticipateDto {

    private static final long serialVersionUID = 7877330208579785580L;

    /**
     * 当前是否可领取
     */
    private Boolean canTake;

    /**
     * 不可领取错误码，canTake 为false时有值
     */
    private String takeErrCode;

    /**
     * 是否已经全部领取结束（没有次数了）
     */
    private Boolean allTake;

    /**
     * 当前是否售罄
     * 注意：canTake 为true 且sellOut 为true时，不能领取
     */
    private Boolean sellOut;

    /**
     * 支付时，当前奖品是否可以支付
     */
    private Boolean canPay;

    /**
     * 不可支付错误码，canPay 为false时有值
     */
    private String payErrCode;


    /**
     * 用户领取统计数据表ID
     */
    private Long userTakeStatId;

    /**
     * 已领取数量，用于校验领取记录并发写入
     */
    private Long takeCount;

    /**
     * 最后一次领取记录ID，用于校验领取记录并发写入
     */
    private Long lastRecordId;

    /**
     * 是否在白名单内
     */
    private Boolean inWhiteList;

    /**
     * 白名单ID(有库存的)
     */
    private Long whiteListId;
}
