package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author xuzhigang
 * @date 2024/9/26 16:51
 **/
@Getter
@AllArgsConstructor
public enum BindMethodEnum {
    NORMAL_BIND(1, "normalbind", "微信端"),
    ONE_CLICK_BIND(2, "oneclickbind", "一键绑卡"),
    FAST_BIND(3, "fastbind", "绑卡码")
    ;

    private final Integer code;
    private final String method;
    private final String desc;

    public static List<String> parseMethodList(List<Integer> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return codeList.stream().map(t -> {
            BindMethodEnum methodEnum = getByCode(t);
            if (methodEnum == null) {
                return null;
            }
            return methodEnum.getMethod();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static BindMethodEnum getByCode(Integer code) {
        return Arrays.stream(values()).filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }
}
