package cn.com.duiba.quanyi.center.api.param.bill.notify;

import cn.com.duiba.quanyi.center.api.enums.bill.BillPushTypeEnum;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 下载结果通知参数
 *
 * @author xuzhigang
 * @date 2024/3/6 11:33
 **/
@Data
public class DownloadResultNotifyParam implements Serializable {
    private static final long serialVersionUID = -5609652837180024945L;

    /**
     * 批次id
     */
    @NotNull(message = "批次id不能为空")
    private String stockId;

    /**
     * 起始时间
     */
    @NotNull(message = "起始时间不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束时间
     */
    @NotNull(message = "结束时间不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date endDate;

    /**
     * 商户号
     */
    @NotNull(message = "商户号不能为空")
    private String mchId;

    /**
     * 下载状态 1-下载中 2-下载完成 3-下载失败
     */
    @NotNull(message = "下载状态不能为空")
    private Integer status;

    /**
     * todo 默认增量
     */
    private Integer pushType;

    public String generateUniqueKey() {
        return StringUtils.join(mchId, stockId, startDate, endDate, BillPushTypeEnum.ZENG_LIANG.getType());
    }
}
