package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityInviteDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityDoAssistParam;
import cn.com.duiba.quanyi.center.api.param.qy.activity.ActivityInviteSearchParam;

import java.util.List;

/**
 * 用户邀请码
 *
 * @author kjj mybatis generator
 * @date 2024-06-20
 */
@AdvancedFeignClient
public interface RemoteActivityInviteService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 用户邀请码集合
     */
    List<ActivityInviteDto> selectPage(ActivityInviteSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityInviteSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 用户邀请码
     */
    ActivityInviteDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 用户邀请码
     * @return 执行结果
     */
    int insert(ActivityInviteDto dto);

    /**
     * 更新
     *
     * @param dto 用户邀请码
     * @return 影响行数
     */
    int update(ActivityInviteDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 查询用户的邀请码
     *
     * @param activityId 活动ID
     * @param userId     分享者用户ID
     */
    ActivityInviteDto getInviteCode(Long activityId, Long userId);

    /**
     * 查询用户的邀请码
     *
     * @param activityId 活动ID
     * @param inviteCode 邀请码
     */
    ActivityInviteDto selectByInviteCodeAndActivityId(Long activityId, String inviteCode);

    /**
     * extra 额外字段
     *
     * @param inviteCode 邀请码
     * @return
     */
    List<ActivityInviteDto> selectByInviteCode(String inviteCode);

    /**
     * 通过邀请码 查询存在的邀请码
     *
     * @param codeList   邀请码集合
     * @param activityId 活动ID
     * @return 查询结果
     */
    List<ActivityInviteDto> selectInviteCodeList(List<String> codeList, Long activityId);

    /**
     * 发起助力
     *
     * @return 助力结果
     */
    Boolean doAssist(ActivityDoAssistParam activityDoAssistParam) throws BizException;


}