/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.settlement;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum;
import cn.com.duiba.quanyi.center.api.enums.bigdata.QueryOperatorTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.settlement.SettlementExcelDimension;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataHologresDownloadParam;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataQueryConditionParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloCreateParam;
import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public enum HoloSettlementDimension {
    DP_RECORD(SettlementExcelDimension.DP.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().stream().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList((Object[])new String[]{HoloSettlementDimension.buildValue(uniqueMark, bean.getSettlementMethod())}))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_DP_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.DP.name());
    }),
    KM_RECORD(SettlementExcelDimension.KM.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList((Object[])new String[]{HoloSettlementDimension.buildValue(uniqueMark, bean.getSettlementMethod())}))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_KM_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.KM.name());
    }),
    OBJECT_RECORD(SettlementExcelDimension.OBJECT.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList((Object[])new String[]{HoloSettlementDimension.buildValue(uniqueMark, bean.getSettlementMethod())}))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_OBJECT_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.OBJECT.name());
    }),
    WX_RECORD(SettlementExcelDimension.WX.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method, wx_bill_type, filter_flag)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().stream().filter(uniqueMark -> uniqueMark.startsWith(SpuTypeEnum.WX_COUPON.getType().toString() + "_")).forEach(uniqueMark -> uniqueMarkList.addAll(HoloSettlementDimension.buildWxValue(uniqueMark, bean.getSettlementMethod(), bean.getWxBillType(), bean.getAdjustmentEnable()))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            if (CollectionUtils.isNotEmpty(uniqueMarkList)) {
                conditionParamList.add(conditionParam);
            } else {
                conditionParam = new BigdataQueryConditionParam();
                conditionParam.setFieldName("1");
                conditionParam.setFieldType(2);
                conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{2}));
                conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
                conditionParamList.add(conditionParam);
            }
        }
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("settlement_flag");
        conditionParam.setFieldType(2);
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{1}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
        conditionParamList.add(conditionParam);
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_WX_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.WX.name());
    }),
    ALIPAY_RECORD(SettlementExcelDimension.ALIPAY.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method, filter_flag)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().stream().filter(uniqueMark -> uniqueMark.startsWith(SpuTypeEnum.ALIPAY_COUPON.getType().toString() + "_")).forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(HoloSettlementDimension.buildValue(uniqueMark, bean.getSettlementMethod(), bean.getAdjustmentEnable())))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            if (CollectionUtils.isNotEmpty(uniqueMarkList)) {
                conditionParamList.add(conditionParam);
            } else {
                conditionParam = new BigdataQueryConditionParam();
                conditionParam.setFieldName("1");
                conditionParam.setFieldType(2);
                conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{2}));
                conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
                conditionParamList.add(conditionParam);
            }
        }
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("settlement_flag");
        conditionParam.setFieldType(2);
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{1}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
        conditionParamList.add(conditionParam);
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_ALIPAY_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.ALIPAY.name());
    }),
    ALIPAY_COIN_RECORD(SettlementExcelDimension.ALIPAY_COIN.name(), (bigdataHologresDownloadParam, param) -> {
        ArrayList conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getStartDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{String.valueOf(DateUtils.getDayNumber((Date)param.getEndDate()))}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        if (CollectionUtils.isNotEmpty(param.getSelectList())) {
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            HashSet uniqueMarkList = new HashSet();
            param.getSelectList().forEach(bean -> bean.getUniqueMarkList().stream().filter(uniqueMark -> uniqueMark.startsWith(SpuTypeEnum.ALIPAY_COUNT_COINS.getType().toString() + "_")).forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList((Object[])new String[]{HoloSettlementDimension.buildValue(uniqueMark, bean.getSettlementMethod())}))));
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList.stream().collect(Collectors.toList()));
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            if (CollectionUtils.isNotEmpty(uniqueMarkList)) {
                conditionParamList.add(conditionParam);
            } else {
                conditionParam = new BigdataQueryConditionParam();
                conditionParam.setFieldName("1");
                conditionParam.setFieldType(2);
                conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{2}));
                conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
                conditionParamList.add(conditionParam);
            }
        }
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("settlement_flag");
        conditionParam.setFieldType(2);
        conditionParam.setFieldValue(Lists.newArrayList((Object[])new Object[]{1}));
        conditionParam.setSymbol(QueryOperatorTypeEnum.EQ.toString());
        conditionParamList.add(conditionParam);
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_ALIPAY_COIN_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.ALIPAY_COIN.name());
    });

    private String dimension;
    private DuiBaBigDateParamBuilder builder;
    private static Map<String, HoloSettlementDimension> calMap;

    public String getDimension() {
        return this.dimension;
    }

    private HoloSettlementDimension(String dimension, DuiBaBigDateParamBuilder builder) {
        this.dimension = dimension;
        this.builder = builder;
    }

    public void builder(BigdataHologresDownloadParam bigDataParam, SettlementHoloCreateParam engineParam) {
        this.builder.builder(bigDataParam, engineParam);
    }

    public static HoloSettlementDimension getHoloSettlementDimension(String dimension) {
        return calMap.get(dimension);
    }

    private static String buildValue(String uniqueMark, Integer settlementMethod) {
        return "('" + uniqueMark + "'," + settlementMethod + ")";
    }

    private static List<String> buildWxValue(String uniqueMark, Integer settlementMethod, Integer wxBillType, Integer adjustmentEnable) {
        ArrayList list = Lists.newArrayList();
        if (!Objects.isNull(adjustmentEnable) & BooleanEnum.FALSE.getCode().equals(adjustmentEnable)) {
            list.add("('" + uniqueMark + "'," + settlementMethod + "," + wxBillType + "," + 1 + ")");
        }
        list.add("('" + uniqueMark + "'," + settlementMethod + "," + wxBillType + "," + 0 + ")");
        return list;
    }

    private static List<String> buildValue(String uniqueMark, Integer settlementMethod, Integer adjustmentEnable) {
        ArrayList list = Lists.newArrayList();
        if (!Objects.isNull(adjustmentEnable) & BooleanEnum.FALSE.getCode().equals(adjustmentEnable)) {
            list.add("('" + uniqueMark + "'," + settlementMethod + "," + 0 + ")");
        }
        return list;
    }

    static {
        calMap = Arrays.stream(HoloSettlementDimension.values()).collect(Collectors.toMap(HoloSettlementDimension::getDimension, Function.identity()));
    }

    @FunctionalInterface
    static interface DuiBaBigDateParamBuilder {
        public void builder(BigdataHologresDownloadParam var1, SettlementHoloCreateParam var2);
    }
}

