package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:06
 */
@Getter
@AllArgsConstructor
public enum InsuranceCompanyBizVersionEnum {
    REN_BAO(1, "人保"),
    TAI_BAO(2, "太保"),
    YUN_YAN(3, "贵州云岩"),
    /**
     * 永坤开发，客户通过接口导入积分，补充枚举
     */
    CHENG_DU_REN_BAO(4, "成都人保"),
    CHANG_SHA(5, "长沙"),
    LAND(6, "大地保险"),
    CHENG_DU_TAI_BAO(7, "成都太保"),
    JD(8, "京东"),
    WU_HAN(9, "武汉"),
    HARBIN(10, "哈尔滨人保"),
    BANK_CUSTOMER(11, "银行（网银客户号）"),
    BANK_CORE_NUMBER(12, "银行（核心客户号）"),
    BANK_PHONE(13, "银行（手机号）"),
    BANK_USERID(14, "银行（用户ID）"),
    GUANGZHOU_REN_BAO(15, "广州人保"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, InsuranceCompanyBizVersionEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceCompanyBizVersionEnum::getType, Function.identity(), (v1, v2) -> v2)));

    public final static List<InsuranceCompanyBizVersionEnum> BANK_BIZ_VERSION = Arrays.asList(InsuranceCompanyBizVersionEnum.BANK_CUSTOMER, InsuranceCompanyBizVersionEnum.BANK_CORE_NUMBER, InsuranceCompanyBizVersionEnum.BANK_PHONE, InsuranceCompanyBizVersionEnum.BANK_USERID);

    public static final Set<Integer> SUPPORT_AUTO_ADD_MONEY_VERSION = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            InsuranceCompanyBizVersionEnum.REN_BAO.getType(),
            InsuranceCompanyBizVersionEnum.TAI_BAO.getType(),
            InsuranceCompanyBizVersionEnum.YUN_YAN.getType(),
            InsuranceCompanyBizVersionEnum.CHANG_SHA.getType(),
            InsuranceCompanyBizVersionEnum.WU_HAN.getType())));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceCompanyBizVersionEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
